(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16806,        643]*)
(*NotebookOutlinePosition[     17645,        670]*)
(*  CellTagsIndexPosition[     17601,        666]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PrintingOptions->{"FirstPageHeader"->False,
  "FirstPageFace"->Right},
  StyleMenuListing->None,
  Background->RGBColor[0.900008, 0.863996, 0.809995]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"B Helvetica Bold",
  FontSize->34,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[1],
  Background->GrayLevel[0],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  FontSize->24,
  FontTracking->"Plain",
  Background->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  PageBreakBelow->False,
  LineSpacing->{1, 3},
  ParagraphIndent->-96,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontColor->GrayLevel[1],
  Background->RGBColor[0.2, 0.700008, 0.700008]],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{0, 0}, {0, 0}},
  ParagraphIndent->-85,
  FontSize->16,
  Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  ShowCellBracket->False,
  CellMargins->{{10, 4}, {30, 10}},
  PageBreakBelow->False,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{9, 10}, {50, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 1}},
  CellDingbat->None,
  CellMargins->{{12, Inherited}, {4, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 4}, {6, 2}},
  CellFrameLabelMargins->2,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{9, 0}, {2, 50}},
  FontSize->14,
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{12, 10}, {25, 0}},
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {4, 40}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellFrame->{{0, 0}, {0, 2}},
  CellMargins->{{12, 10}, {5, 20}},
  CellFrameMargins->{{0, 0}, {0, 2}},
  CellFrameColor->GrayLevel[1],
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[0.4, 0, 0.6]],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{19, 0}, {4, 20}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {5, 5}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellMargins->{{52, 10}, {0, 10}},
  PageBreakBelow->False,
  CellFrameMargins->{{0, 0}, {0, 2}},
  CellFrameColor->GrayLevel[1],
  LineSpacing->{1, 0},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{4, 4}, {0, 4}},
  CellMargins->{{52, 10}, {0, 2}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontWeight->"Bold",
  Background->GrayLevel[1]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{37, 0}, {6, 6}},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{4, 4}, {4, 0}},
  CellMargins->{{52, 10}, {12, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  Background->GrayLevel[1]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{37, 0}, {6, 2}},
  Background->GrayLevel[0.900008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->4,
  CellMargins->{{52, 10}, {4, 2}},
  Evaluatable->True,
  CellGroupingRules->"NormalGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  FontWeight->"Bold",
  Background->GrayLevel[1]],

Cell[StyleData["InputOnly", "Printing"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutputOnly"],
  CellFrame->4,
  CellMargins->{{52, 10}, {4, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  Background->GrayLevel[1]],

Cell[StyleData["OutputOnly", "Printing"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SymbolicExpression"],
  CellFrame->1,
  CellMargins->{{52, 10}, {4, 2}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  CellFrameColor->GrayLevel[0],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell[StyleData["SymbolicExpression", "Printing"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{52, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{30, Inherited}, {Inherited, Inherited}},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{52, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{30, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Info"],
  CellMargins->{{52, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{21, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->None],

Cell[StyleData["Info", "Printout"],
  CellMargins->{{30, Inherited}, {Inherited, Inherited}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{4, 4}, {0, 0}},
  CellMargins->{{52, 10}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["Graphics", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ImportPict"],
  CellMargins->{{52, 10}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  StyleMenuListing->"ImportPict",
  Background->None],

Cell[StyleData["ImportPict", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0.4, 0.4, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Unique Items", "Section"],

Cell[CellGroupData[{

Cell[StyleData["PullQuote"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{0, 250}, {15, 5}},
  CellFrameMargins->{{20, 4}, {8, 6}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[1],
  Background->RGBColor[0.6, 0, 0.8]],

Cell[StyleData["PullQuote", "Printout"],
  CellMargins->{{9, 0}, {4, 4}},
  ParagraphSpacing->{0, 6},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GrayBox"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{62, 36}, {10, 5}},
  CellFrameMargins->{{8, 4}, {8, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 12},
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontColor->GrayLevel[0],
  Background->RGBColor[0.8, 0.700008, 0.6]],

Cell[StyleData["GrayBox", "Printout"],
  CellMargins->{{62, 36}, {10, 5}},
  Background->GrayLevel[0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{4, 4}, {0, 0}},
  CellMargins->{{52, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  CellFrameColor->RGBColor[0.8, 0.700008, 0.6],
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[1]],

Cell[StyleData["PictureGroup", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{28, Inherited}, {Inherited, 0}}]
}, Closed]],

Cell[StyleData["LineSpace"],
  CellMargins->{{0, 0}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->2},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->6],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  CellFrame->1,
  CellMargins->{{52, 10}, {4, 2}},
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->10,
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{484, 371},
WindowMargins->{{9, Automatic}, {Automatic, 4}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2291, 76, 35, 0, 30, "Section"],
Cell[2329, 78, 101, 3, 70, "Text"],
Cell[2433, 83, 525, 13, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[2995, 101, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3058, 105, 457, 15, 74, 24, 0, "StyleData", "Title", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3518, 122, 138, 4, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3693, 131, 349, 10, 54, 27, 0, "StyleData", "Subtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4045, 143, 142, 4, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4224, 152, 255, 7, 65, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4482, 161, 94, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4613, 168, 447, 13, 45, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5063, 183, 140, 4, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5240, 192, 144, 4, 58, 29, 0, "StyleData", "Subsection", "All"],
Cell[5387, 198, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5515, 205, 345, 11, 42, 32, 0, "StyleData", "Subsubsection", "All"],
Cell[5863, 218, 95, 2, 55, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6007, 226, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[6071, 230, 137, 4, 39, 23, 0, "StyleData", "Text", "All"],
Cell[6211, 236, 112, 3, 35, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6360, 244, 300, 10, 31, 29, 0, "StyleData", "Commentary", "All"],
Cell[6663, 256, 118, 3, 35, 41, 0, "StyleData", "Commentary", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6830, 265, 42, 0, 30, "Section"],
Cell[6875, 267, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[7148, 276, 521, 15, 43, 24, 0, "StyleData", "Input", "All"],
Cell[7672, 293, 100, 2, 61, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[7787, 298, 375, 12, 37, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[8187, 314, 508, 14, 52, 25, 0, "StyleData", "Output", "All"],
Cell[8698, 330, 106, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8841, 337, 511, 15, 61, 28, 0, "StyleData", "InputOnly", "All"],
Cell[9355, 354, 40, 0, 70, 40, 0, "StyleData", "InputOnly", "Printing"]
}, Closed]],

Cell[CellGroupData[{
Cell[9432, 359, 496, 14, 60, 29, 0, "StyleData", "OutputOnly", "All"],
Cell[9931, 375, 41, 0, 70, 41, 0, "StyleData", "OutputOnly", "Printing"]
}, Closed]],

Cell[CellGroupData[{
Cell[10009, 380, 662, 21, 54, 37, 0, "StyleData", "SymbolicExpression", 
"All"],
Cell[10674, 403, 49, 0, 70, 49, 0, "StyleData", "SymbolicExpression", 
"Printing"]
}, Closed]],

Cell[CellGroupData[{
Cell[10760, 408, 446, 12, 36, 26, 0, "StyleData", "Message", "All",
  StyleMenuListing->None],
Cell[11209, 422, 123, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11369, 429, 445, 12, 36, 24, 0, "StyleData", "Print", "All",
  StyleMenuListing->None],
Cell[11817, 443, 94, 1, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11948, 449, 444, 12, 36, 23, 0, "StyleData", "Info", "All",
  StyleMenuListing->None],
Cell[12395, 463, 93, 1, 70, 35, 0, "StyleData", "Info", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12525, 469, 491, 14, 32, 27, 0, "StyleData", "Graphics", "All",
  StyleMenuListing->None],
Cell[13019, 485, 115, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13171, 492, 312, 9, 32, 29, 0, "StyleData", "ImportPict", "All",
  StyleMenuListing->"ImportPict"],
Cell[13486, 503, 41, 0, 70, 41, 0, "StyleData", "ImportPict", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13564, 508, 179, 6, 35, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13746, 516, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13925, 526, 42, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[13992, 530, 315, 10, 66, 28, 0, "StyleData", "PullQuote", "All"],
Cell[14310, 542, 117, 3, 70, 40, 0, "StyleData", "PullQuote", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14464, 550, 320, 10, 56, 26, 0, "StyleData", "GrayBox", "All"],
Cell[14787, 562, 104, 2, 70, 38, 0, "StyleData", "GrayBox", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14928, 569, 381, 10, 32, 31, 0, "StyleData", "PictureGroup", "All",
  StyleMenuListing->None],
Cell[15312, 581, 119, 2, 28, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]],
Cell[15446, 586, 121, 3, 30, 28, 0, "StyleData", "LineSpace", "All"]
}, Closed]],

Cell[CellGroupData[{
Cell[15604, 594, 49, 0, 30, "Section"],
Cell[15656, 596, 149, 5, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[15808, 603, 126, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[15937, 609, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[16126, 619, 36, 0, 30, "Section"],
Cell[16165, 621, 258, 5, 62, "Text"],
Cell[16426, 628, 352, 11, 51, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

